package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;

/**
 * The Class LookUpDaoTest.
 *
 * @author Getaneh Kassahun
 * 
 *         The Class LookUpDaoTest.
 * 
 *         Description: In this LookUpDaoTest Class which extends the abstract
 *         class, AbstractMockMvcTests, junit tests are defined.
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class LookUpDaoTest extends AbstractMockMvcTests {

	/** The logger. */
	private final Logger logger = LoggerFactory.getLogger(LookUpDaoTest.class);

	/** The lookUpDao. */
	@Autowired
	private ILookUpDao lookUpDao;

	/**
	 * Test get status id 0.
	 * 
	 * @throws GenisisDAOException
	 */
	@Test
	public void testGetStatusId() throws GenisisDAOException {
		assertEquals(0, lookUpDao.getStatusId("null"));
		assertEquals(1, lookUpDao.getStatusId("Draft"));
		assertEquals(2, lookUpDao.getStatusId("Submitted"));
		assertEquals(3, lookUpDao.getStatusId("Denied"));
		assertEquals(4, lookUpDao.getStatusId("Returned"));
		assertEquals(5, lookUpDao.getStatusId("Sent"));
		assertEquals(6, lookUpDao.getStatusId("Update"));
		assertEquals(7, lookUpDao.getStatusId("RequestAccepted"));
		assertEquals(8, lookUpDao.getStatusId("RequestNotAccepted"));
		assertEquals(9, lookUpDao.getStatusId("ResultsAccepted"));
		assertEquals(10, lookUpDao.getStatusId("ResultsNotAccepted"));
	}

	/**
	 * Test get RequestType.
	 */
	@Test
	public void testGetRequestType() throws GenisisDAOException {

		logger.info("**********Junit Test get RequestType**********");
		RequestType requestType = lookUpDao.getRequestType(1);
		assertEquals("Aggregate", requestType.getDescription());

	}

	/**
	 * Test get GetSource.
	 */
	@Test
	public void testGetSource() throws GenisisDAOException {

		logger.info("**********Junit Test get Source**********");
		Source sourceType = lookUpDao.getSource(1);
		assertEquals("Survey", sourceType.getDescription());

	}

	/**
	 * Test get DataSources.
	 */
	@Test
	public void testgetDataSources() throws GenisisDAOException {

		logger.info("**********Junit Test get DataSources**********");
		List<Source> sourceList = lookUpDao.getDataSources();
		assertEquals("Survey", sourceList.get(0).getDescription());

	}

	/**
	 * Test get RequestTypes.
	 */
	@Test
	public void testGetRequestTypes() throws GenisisDAOException {

		logger.info("**********Junit Test get RequestTypes**********");
		List<RequestType> requestTypeList = lookUpDao.getRequestTypes();
		assertEquals("Aggregate", requestTypeList.get(0).getDescription());

	}

}
